uniform sampler3D volumeTexture;
uniform sampler1D transferTexture;
uniform sampler2D frontTexture;
uniform sampler2D backTexture;
uniform sampler2D colorTexture;
uniform float stepDist;
uniform int startStep;

void main()
{
	vec4 startPoint = texture2D(frontTexture, gl_TexCoord[0].st);

	if(startPoint.w == 0.0)
	{
		discard;
	}
	else
	{
		vec4 endPoint = texture2D(backTexture, gl_TexCoord[0].st);
		float maxIntensity = texture2D(colorTexture, gl_TexCoord[0].st).w;
		vec3 iterDiff = (endPoint.xyz - startPoint.xyz) * stepDist;

		vec3 currPoint = startPoint.xyz + iterDiff * startStep;

		for(int i = 0;i < #;i++)
		{
			float tmpIntensity = texture3D(volumeTexture, currPoint).x;
			//float tmpIntensity = texture3D(volumeTexture, currPoint).x;

			maxIntensity = max(tmpIntensity, maxIntensity);
			currPoint += iterDiff;
		}
		
		gl_FragColor = vec4(0, 0, 0, maxIntensity);
	}
}